<?php

return [
    'app' => [
        'name' => 'Gayrimenkul AI Asistanı',
        'version' => '1.0.0',
        'debug' => true,
        'timezone' => 'Europe/Istanbul',
        'language' => 'tr_TR'
    ],
    
    'elevenlabs' => [
        'api_key' => 'sk_1aee191a5c02cb999a685355831b0d8e248bb07d9a46f715',
        'base_url' => 'https://api.elevenlabs.io/v1',
        'agent_id' => 'xDShwZSUulMFfuMcGqX2',
        'voice_id' => 'IuRRIAcbQK5AQk1XevPj',
        'phone_number_id' => 'phnum_01jwxzvgr0fprrp70axpyhnrf1',
        'model' => 'eleven_multilingual_v2',
        'language' => 'turkish',
        'timeout' => 30
    ],
    
    'assistant' => [
        'name' => 'Ayşe Kaya', // AI asistanının adı
        'role' => 'Gayrimenkul Danışmanı',
        'company' => 'Elite Gayrimenkul',
        'greeting' => [
            'formal' => 'Merhaba, ben {name}, {company} gayrimenkul danışmanıyım. Size nasıl yardımcı olabilirim?',
            'friendly' => 'Selam! Ben {name}. Gayrimenkul konusunda aradığınız her şeyde yanınızdayım.',
            'professional' => 'İyi günler. {name}, {company} danışmanı. Emlak ihtiyaçlarınızla ilgili bilgi almak için mi aradınız?'
        ],
        'personality' => [
            'tone' => 'professional_friendly',
            'style' => 'direct_helpful',
            'pace' => 'moderate',
            'expertise_areas' => [
                'konut_satis', 'konut_kira', 'ticari_gayrimenkul', 
                'arsa_arazi', 'yatirim_danismanligi', 'mortgage_kredisi'
            ]
        ]
    ],
    
    'database' => [
        'host' => $_ENV['DB_HOST'] ?? 'localhost',
        'name' => $_ENV['DB_NAME'] ?? 'gayrimenkul_ai',
        'user' => $_ENV['DB_USER'] ?? 'root',
        'password' => $_ENV['DB_PASSWORD'] ?? '',
        'charset' => 'utf8mb4',
        'port' => $_ENV['DB_PORT'] ?? 3306
    ],
    
    'knowledge_base' => [
        'max_file_size' => 20 * 1024 * 1024, // 20MB
        'allowed_formats' => ['pdf', 'txt', 'docx', 'html'],
        'categories' => [
            'genel_bilgiler' => 'Genel Gayrimenkul Bilgileri',
            'satis_surecler' => 'Satış Süreçleri',
            'kira_surecler' => 'Kiralama Süreçleri',
            'hukuki_konular' => 'Hukuki Konular',
            'kredi_mortgage' => 'Kredi ve Mortgage',
            'yatirim_rehberi' => 'Yatırım Rehberi',
            'bolge_analiz' => 'Bölge Analizleri',
            'fiyat_listesi' => 'Güncel Fiyat Listeleri'
        ]
    ],
    
    'call_settings' => [
        'max_duration' => 30 * 60, // 30 dakika
        'recording_enabled' => true,
        'auto_summary' => true,
        'follow_up_enabled' => true,
        'quality_analysis' => true
    ],
    
    'twilio' => [
        'phone_number_id' => 'phnum_01jwxzvgr0fprrp70axpyhnrf1',
        'enabled' => true
    ],
    
    'features' => [
        'voice_calling' => true,
        'web_chat' => true,
        'appointment_booking' => true,
        'property_search' => true,
        'document_sharing' => true,
        'video_calls' => false, // Gelecekte eklenebilir
        'whatsapp_integration' => false // Gelecekte eklenebilir
    ]
]; 