<?php

try {
    // Get request method and data
    $method = $_SERVER['REQUEST_METHOD'];
    $requestUri = $_SERVER['REQUEST_URI'];
    $path = parse_url($requestUri, PHP_URL_PATH);
    
    // Initialize services
    $elevenlabsService = new ElevenlabsService($config);
    
    if ($method === 'GET' && strpos($path, '/api/voices/list') !== false) {
        // Get available voices
        $voices = $elevenlabsService->getVoices();
        
        if (isset($voices['voices'])) {
            // Format voices for dropdown
            $formattedVoices = [];
            foreach ($voices['voices'] as $voice) {
                $formattedVoices[] = [
                    'voice_id' => $voice['voice_id'],
                    'name' => $voice['name'],
                    'category' => $voice['category'] ?? 'generated',
                    'language' => $voice['labels']['language'] ?? 'english',
                    'accent' => $voice['labels']['accent'] ?? '',
                    'description' => $voice['labels']['description'] ?? '',
                    'use_case' => $voice['labels']['use case'] ?? ''
                ];
            }
            
            // Sort by name
            usort($formattedVoices, function($a, $b) {
                return strcmp($a['name'], $b['name']);
            });
            
            echo json_encode([
                'success' => true,
                'voices' => $formattedVoices,
                'total_count' => count($formattedVoices),
                'current_voice' => $config['elevenlabs']['voice_id']
            ]);
        } else {
            throw new Exception('Ses listesi alınamadı');
        }
        
    } elseif ($method === 'POST' && strpos($path, '/api/voices/select') !== false) {
        // Update selected voice
        $input = json_decode(file_get_contents('php://input'), true);
        $voiceId = $input['voice_id'] ?? '';
        $voiceName = $input['voice_name'] ?? '';
        
        if (empty($voiceId)) {
            http_response_code(400);
            echo json_encode(['success' => false, 'error' => 'Voice ID gerekli']);
            exit;
        }
        
        // Update config file
        $configFile = 'src/config/config.php';
        $configContent = file_get_contents($configFile);
        
        // Replace voice_id in config
        $pattern = "/'voice_id' => '[^']*'/";
        $replacement = "'voice_id' => '{$voiceId}'";
        $newConfigContent = preg_replace($pattern, $replacement, $configContent);
        
        if ($newConfigContent && $newConfigContent !== $configContent) {
            file_put_contents($configFile, $newConfigContent);
            
            echo json_encode([
                'success' => true,
                'message' => "Ses başarıyla değiştirildi: {$voiceName}",
                'voice_id' => $voiceId,
                'voice_name' => $voiceName
            ]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'error' => 'Konfigürasyon güncellenemedi']);
        }
        
    } elseif ($method === 'GET' && strpos($path, '/api/voices/current') !== false) {
        // Get current voice info
        $currentVoiceId = $config['elevenlabs']['voice_id'];
        $voices = $elevenlabsService->getVoices();
        
        $currentVoice = null;
        if (isset($voices['voices'])) {
            foreach ($voices['voices'] as $voice) {
                if ($voice['voice_id'] === $currentVoiceId) {
                    $currentVoice = [
                        'voice_id' => $voice['voice_id'],
                        'name' => $voice['name'],
                        'category' => $voice['category'] ?? 'generated',
                        'language' => $voice['labels']['language'] ?? 'english'
                    ];
                    break;
                }
            }
        }
        
        echo json_encode([
            'success' => true,
            'current_voice' => $currentVoice,
            'voice_id' => $currentVoiceId
        ]);
        
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'error' => 'Endpoint bulunamadı']);
    }

} catch (Exception $e) {
    error_log('Voices API Error: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?> 