<?php
session_start();

// Error reporting for development
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load configuration
$config = require_once 'src/config/config.php';

// Set timezone
$timezone = isset($config['app']['timezone']) ? $config['app']['timezone'] : 'Europe/Istanbul';
date_default_timezone_set($timezone);

// Simple autoloader
spl_autoload_register(function ($class) {
    $paths = [
        'src/backend/' . $class . '.php',
        'src/api/' . $class . '.php'
    ];
    
    foreach ($paths as $path) {
        if (file_exists($path)) {
            require_once $path;
            return;
        }
    }
});

// Environment variables loader
function loadEnv($file = '.env') {
    if (!file_exists($file)) {
        return;
    }
    
    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos($line, '#') === 0 || strpos($line, '=') === false) {
            continue;
        }
        
        list($key, $value) = explode('=', $line, 2);
        $_ENV[trim($key)] = trim($value);
    }
}

// Load environment variables
loadEnv();

// Simple routing
$requestUri = $_SERVER['REQUEST_URI'];
$path = parse_url($requestUri, PHP_URL_PATH);
$method = $_SERVER['REQUEST_METHOD'];

// API Routes
if (strpos($path, '/api/') === 0) {
    header('Content-Type: application/json');
    
    switch ($path) {
        case '/api/agent/create':
            if ($method === 'POST') {
                require_once 'src/api/agent.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/conversation/start':
            if ($method === 'POST') {
                require_once 'src/api/conversation.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/conversation':
            // Handle all conversation endpoints (GET for status/transcript, POST for start/send)
            require_once 'src/api/conversation.php';
            break;
            
        case '/api/conversation/send':
            if ($method === 'POST') {
                require_once 'src/api/conversation.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/knowledge/add':
            if ($method === 'POST') {
                require_once 'src/api/knowledge.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/knowledge/list':
            if ($method === 'GET') {
                require_once 'src/api/knowledge.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/knowledge/initialize':
            if ($method === 'POST') {
                require_once 'src/api/knowledge.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/test':
            if ($method === 'GET') {
                require_once 'src/api/test.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/voices/list':
            if ($method === 'GET') {
                require_once 'src/api/voices.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/voices/select':
            if ($method === 'POST') {
                require_once 'src/api/voices.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        case '/api/voices/current':
            if ($method === 'GET') {
                require_once 'src/api/voices.php';
            } else {
                http_response_code(405);
                echo json_encode(['error' => 'Method not allowed']);
            }
            break;
            
        default:
            http_response_code(404);
            echo json_encode(['error' => 'API endpoint not found']);
            break;
    }
} else {
    // Frontend Routes
    switch ($path) {
        case '/':
        case '/index.php':
            require_once 'src/frontend/dashboard.php';
            break;
            
        case '/admin':
            require_once 'src/frontend/admin.php';
            break;
            
        case '/test':
            require_once 'src/frontend/test.php';
            break;
            
        default:
            http_response_code(404);
            echo "404 - Sayfa Bulunamadı";
            break;
    }
}
?> 